`timescale 100ps/10ps

////////////////////////////////////////////////////////////////////////////////////
//  DENSITY SELECTION                                                             //
//                                                                                //
//  Uncomment one of the following lines to select the appropriate density. If    //
//  no line is selected, the model will default to 8Gb (4Gb per lane)             //
//                                                                                //
////////////////////////////////////////////////////////////////////////////////////
//`define DENSITY_1G // 1Gb (512Mb per lane)
`define DENSITY_2G // 2Gb (1Gb per lane)
//`define DENSITY_4G // 4Gb (2Gb per lane)
//`define DENSITY_8G // 8Gb (4Gb per lane)

`ifdef TEST_ADDRPROT
`include "./stimulus_addrprot.v"
`elsif TEST_DDR
`include "./stimulus_ddr.v"
`elsif TEST_REG
`include "./stimulus_reg.v"
`elsif TEST_ALT
`include "./stimulus_alternate.v"
`elsif TEST_XIP
`include "./stimulus_xip.v"
`elsif TEST_DUALLANE
`include "./stimulus_DL.v"
`else
`include "./stimulus.v"
`endif

`include "./spsram_as3xxg208.v"

module test;
  
  wire [7:0] IO;
  wire CS1n,CS2n;
  wire CLK1, CLK2;
  wire [2:0] HBP;
  wire HTBSEL;
  reg RESETn;

  //spsram_as302g208 M0
  spsram_as3xxg208 M0
    (
    .IO(IO),
    .CS1n(CS1n),
    .CS2n(CS2n),
    .CLK1(CLK1),
    .CLK2(CLK2),
    .HBP(HBP),
    .HTBSEL(HTBSEL),
    .RESETn(RESETn)
    );

  stimulus inst_stimulus
    (
    .IO(IO),
    .CS1n(CS1n), 
    .CS2n(CS2n), 
    .CLK1(CLK1),
    .CLK2(CLK2),
    .HBP(HBP),
    .HTBSEL(HTBSEL)
    );

  initial begin
    RESETn = 1'b1;
`ifdef TEST_RESET
    #(250000) RESETn = 0;
    #(2000) RESETn = 1'b1;
`endif
  end

  // Synopsys VCS dump
  initial begin
    $vcdpluson;
  end

  // Cadence dump
  //initial begin
  //  $shm_open("test.shm");
  //  $shm_probe(test, "ACM");
  //end
endmodule
